<%@ Page Language="C#" AutoEventWireup="true" Codebehind="AuditSettingsWizard.aspx.cs" Inherits="MarUI.Audit.AuditSettingsWizard" %>

<%@ Register Src="../Admin/UserControls/NavigationBar.ascx" TagName="NavigationBar" TagPrefix="ma" %>
<%@ Register Src="UserControls/SqlAuthentication.ascx" TagName="SQLAuthentication" TagPrefix="ma" %>
<%@ Register Src="UserControls/SelectAuditDB.ascx" TagName="SelectAuditDB" TagPrefix="ma" %>
<%@ Register Src="UserControls/EnableTracing.ascx" TagName="EnableTracing" TagPrefix="ma" %>
<%@ Register Src="UserControls/EnableUserInteraction.ascx" TagName="EnableUserInteraction" TagPrefix="ma" %>
<%@ Register Src="UserControls/Summary.ascx" TagName="Summary" TagPrefix="ma" %>
<%@ Register Src="UserControls/Configure.ascx" TagName="Configure" TagPrefix="ma" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="GFI.Common.Web.Localization" Namespace="GFI.Common.Web.Localization" TagPrefix="localization" %>


<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="MarcStyles" runat="server" rel="stylesheet" type="text/css" />
    <script id="jqScript" runat="server" type="text/javascript"></script>

    <telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
        <script type="text/javascript">
        $(document).ready(function() {
            $("input[type='submit']").mouseover (function(){
                this.className='button button_highlight';
            })
            
            $("input[type='submit']").mouseout (function(){
                this.className='button';
            })
        });                
        
        function GetRadWindow()    
        {      
            var oWindow = null;      
                        
            if (window.radWindow)
            {                
                oWindow = window.RadWindow; //Will work in Moz in all cases, including clasic dialog
                
                if(oWindow == null)
                {
                    if (window.frameElement.radWindow)
                    {
                        oWindow = window.frameElement.radWindow;//IE (and Moz as well)      
                    }
                }      
            }
            else if (window.frameElement.radWindow)
            {
                oWindow = window.frameElement.radWindow;//IE (and Moz as well)      
            }
            
            return oWindow;                
        }      
     
        function Close(arg)      
        {      
            GetRadWindow().Close(arg);
        }

        function EnableFinish() {
            var FinishButton = $('#btnFinish');

            FinishButton.removeAttr('disabled');
            FinishButton.hide();
            FinishButton.show();

            FinishButton = null;
        }

        function ChangeFinishToClose() {
            var FinishButton = $('#btnFinish');

            FinishButton.removeAttr('onclick');
            FinishButton.click(function () { Close(this); });

            FinishButton = null;
        }  
        </script>
    </telerik:RadScriptBlock>

    <style type="text/css">
        * 
        {
            padding:0;
            margin:0;
        }        
    </style>
</head>
<body style="background-color: #ffffff; height: 100%; overflow:hidden">
    <form id="form1" runat="server" style="padding-left: 0px; padding-right: 0px;">
        <!-- SCRIPT MANAGER -->
        <telerik:RadScriptManager AsyncPostBackTimeout="300" ID="RadScriptManagerMain" runat="server">
        </telerik:RadScriptManager>
        <!-- AJAX MANAGER -->
        <telerik:RadAjaxManager ID="AjaxManagerMaster" runat="server">
            <ClientEvents />
        </telerik:RadAjaxManager>
        <telerik:RadFormDecorator ID="FormDecorator1" runat="server" DecoratedControls="RadioButtons,Checkboxes">
        </telerik:RadFormDecorator>
        <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" LoadingPanelID="pnlLoading">
            <!-- WIZARD -->
            <asp:Wizard ID="AuditConfigWizard" runat="server" ActiveStepIndex="0" DisplaySideBar="false"
                Width="100%" OnNextButtonClick="AuditConfigWizard_NextButtonClick" OnPreviousButtonClick="AuditConfigWizard_PreviousButtonClick"
                OnLoad="AuditConfigWizard_Load">
                <WizardSteps>
                    <asp:WizardStep ID="wsSQLAuthentication" runat="server">
                        <ma:SQLAuthentication ID="ctrSQLAuthentication" runat="server" />
                    </asp:WizardStep>
                    <asp:WizardStep ID="wsSelectAuditDB" runat="server">
                        <ma:SelectAuditDB ID="ctrSelectAuditDB" runat="server" />
                    </asp:WizardStep>
                    <asp:WizardStep ID="wsEnableTracing" runat="server">
                        <ma:EnableTracing ID="ctrEnableTracing" runat="server" />
                    </asp:WizardStep>
                    <asp:WizardStep ID="wsEnableUserInteraction" runat="server">
                        <ma:EnableUserInteraction ID="ctrEnableUserInteraction" runat="server" />
                    </asp:WizardStep>
                    <asp:WizardStep ID="wsSummary" runat="server">
                        <ma:Summary ID="ctrSummary" runat="server" />
                    </asp:WizardStep>
                    <asp:WizardStep ID="wsConfigure" runat="server">
                        <ma:Configure ID="ctrConfigure" runat="server" />
                    </asp:WizardStep>
                </WizardSteps>
                <StartNavigationTemplate>
                    <ma:NavigationBar ID="CtrlStartNavigationBarStart" ShowBackButton="false" ShowNextButton="true"
                        ShowFinishButton="false" ShowCancelButton="true" runat="server" />
                </StartNavigationTemplate>
                <StepNavigationTemplate>
                    <ma:NavigationBar ID="CtrlStepNavigationBarStep" ShowBackButton="true" ShowNextButton="true"
                        ShowFinishButton="false" ShowCancelButton="true" runat="server" />
                </StepNavigationTemplate>
                <FinishNavigationTemplate>
                    <ma:NavigationBar ID="CtrlFinishNavigationBarFinish" ShowBackButton="false" ShowNextButton="false"
                        ShowFinishButton="true" ShowCancelButton="false" runat="server" />
                </FinishNavigationTemplate>
            </asp:Wizard>
        </telerik:RadAjaxPanel>
        <!-- AJAX PANEL -->
        <telerik:RadAjaxLoadingPanel Transparency="30" ID="pnlLoading" runat="server" AnimationDuration="20">
            <div style="background-color: #ffffff; height: 100%; width: 100%;">
                <table style="top: 50%; left: 50%; position: absolute; width: 100px; height: 100px;
                    margin-left: -50px; margin-top: -50px;">
                    <tr>
                        <td style="vertical-align: middle; text-align: center;">
                            <asp:Image ID="imgLoading" runat="server" ImageUrl="Images/Icons/animated/loading.gif" />
                        </td>
                    </tr>
                    <tr>
                        <td style="vertical-align: middle; text-align: center;">
                            <b>
                                <%= spAdmin.GetString("Common.LoadingPanel.lblLoading")%>
                            </b>
                        </td>
                    </tr>
                </table>
            </div>
        </telerik:RadAjaxLoadingPanel>
        <!-- STRINGS PROVIDER -->
        <localization:StringsProvider ID="spAdmin" ResourceFileName="strings.admin" runat="server">
        </localization:StringsProvider>
    </form>
</body>
</html>
